unit main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, CPort, ComCtrls;

type
  TForm1 = class(TForm)
    ComPort1: TComPort;
    Edit1: TEdit;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    Label1: TLabel;
    ProgressBar1: TProgressBar;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    procedure ComPort1RxChar(Sender: TObject; Count: Integer);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure CheckBox1Click(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  Out_Buffer:char;

implementation

{$R *.dfm}

procedure TForm1.ComPort1RxChar(Sender: TObject; Count: Integer);
var InBuffer:array[0..1] of byte;
    ADC_Hi,ADC_lo:byte;
    ADCRes:word;
    volt:double;
begin
        ComPort1.Read(InBuffer,2);
        ADC_Hi:=InBuffer[0];
        ADC_Lo:=InBuffer[1];
        ADCRes:=(ADC_Hi shl 8) or ADC_Lo;
        Volt:=(5*ADCRes)/$3FF;
        edit1.Text:=FloatToStrF(Volt,ffFixed,3,2);
        Progressbar1.Position:=round((100*ADCRes)/$3FF);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
        Comport1.Open;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
        Comport1.Close;
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
       if CheckBox1.Checked then
        ComPort1.WriteStr('1')
       else
        ComPort1.WriteStr('2');
end;

procedure TForm1.CheckBox2Click(Sender: TObject);
begin
        if CheckBox2.Checked then
          ComPort1.WriteStr('3')
        else
          ComPort1.WriteStr('4');
end;

end.
